<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Model;

use Amasty\Gdpr\Model\Consent\ConsentStore\ConsentStore;
use Amasty\Gdpr\Model\Consent\DataProvider\AbstractDataProvider;
use Amasty\Gdpr\Model\Consent\ResourceModel\Collection;
use Amasty\Gdpr\Model\ConsentLogger;

class ConsentsDataProvider extends AbstractDataProvider
{
    public function getData(string $location = null, int $storeId = null): array
    {
        if (!$this->config->isModuleEnabled()) {
            return [];
        }

        switch ($location) {
            case null:
                return $this->getAllConsents((int)$storeId);
            case ConsentLogger::FROM_PRIVACY_SETTINGS:
                return $this->getPrivacySettingsConsents((int)$storeId);
            default:
                if ($storeId !== null) {
                    $this->storeManager->setCurrentStore($storeId);
                }
                return $this->getConsentCollection($location);
        }
    }

    private function getAllConsents(int $storeId): array
    {
        $collection = $this->collectionFactory->create();
        $collection->addStoreData($storeId)
            ->addFieldToFilter(ConsentStore::IS_ENABLED, true)
            ->addOrder(ConsentStore::SORT_ORDER, Collection::SORT_ORDER_ASC);

        return $collection->getItems();
    }

    private function getPrivacySettingsConsents(int $storeId): array
    {
        $collection = $this->collectionFactory->create();
        $collection->addStoreData($storeId)
            ->addFieldToFilter(ConsentStore::IS_ENABLED, true)
            ->addFieldToFilter(ConsentStore::HIDE_CONSENT_AFTER_USER_LEFT_THE_CONSENT, true)
            ->addOrder(ConsentStore::SORT_ORDER, Collection::SORT_ORDER_ASC);

        return array_filter($collection->getItems(), function ($consent) {
            return $this->isNeedShowConsentByCountry($consent) && $consent->isLogTheConsent();
        });
    }
}
