<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Cookie Hyva Compatibility (System)
 */

namespace Amasty\GdprCookieHyva\ViewModel;

use Amasty\GdprCookie\Model\ConfigProvider;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class Settings implements ArgumentInterface
{
    private const DEFAULT_BAR_BACKGROUND = '#fff';
    private const DEFAULT_BAR_LINK_COLOR = '#3b82f6';
    private const DEFAULT_BAR_TEXT_COLOR = '#374151';
    private const DEFAULT_BUTTON_BACKGROUND = '#337ab7';
    private const DEFAULT_BUTTON_TEXT_COLOR = '#fff';

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    public function getPolicyTextColor(): string
    {
        return $this->configProvider->getPolicyTextColor() ?: self::DEFAULT_BAR_TEXT_COLOR;
    }

    public function getBackgroundColor(): string
    {
        return $this->configProvider->getBackgroundColor() ?: self::DEFAULT_BAR_BACKGROUND;
    }

    public function getAcceptButtonColor(): string
    {
        return $this->configProvider->getAcceptButtonColor() ?: self::DEFAULT_BUTTON_BACKGROUND;
    }

    public function getAcceptButtonColorHover(): string
    {
        return $this->configProvider->getAcceptButtonColorHover() ?: self::DEFAULT_BUTTON_BACKGROUND;
    }

    public function getAcceptTextColor(): string
    {
        return $this->configProvider->getAcceptTextColor() ?: self::DEFAULT_BUTTON_TEXT_COLOR;
    }

    public function getAcceptTextColorHover(): string
    {
        return $this->configProvider->getAcceptTextColorHover() ?: self::DEFAULT_BUTTON_TEXT_COLOR;
    }

    public function getAcceptButtonOrder(): int
    {
        return (int)$this->configProvider->getAcceptButtonOrder();
    }

    public function getLinksColor(): string
    {
        return $this->configProvider->getLinksColor() ?: self::DEFAULT_BAR_LINK_COLOR;
    }

    public function getSettingsButtonColor(): string
    {
        return $this->configProvider->getSettingsButtonColor() ?: self::DEFAULT_BUTTON_BACKGROUND;
    }

    public function getSettingsButtonColorHover(): string
    {
        return $this->configProvider->getSettingsButtonColorHover() ?: self::DEFAULT_BUTTON_BACKGROUND;
    }

    public function getSettingsTextColor(): string
    {
        return $this->configProvider->getSettingsTextColor() ?: self::DEFAULT_BUTTON_TEXT_COLOR;
    }

    public function getSettingsTextColorHover(): string
    {
        return $this->configProvider->getSettingsTextColorHover() ?: self::DEFAULT_BUTTON_TEXT_COLOR;
    }

    public function getSettingsButtonOrder(): int
    {
        return (int)$this->configProvider->getSettingsButtonOrder();
    }

    public function getTitleTextColor(): string
    {
        return $this->configProvider->getTitleTextColor() ?: self::DEFAULT_BAR_TEXT_COLOR;
    }

    public function getDescriptionTextColor(): string
    {
        return $this->configProvider->getDescriptionTextColor() ?: self::DEFAULT_BAR_TEXT_COLOR;
    }

    public function getDeclineButtonColor(): string
    {
        return $this->configProvider->getDeclineButtonColor() ?: self::DEFAULT_BUTTON_BACKGROUND;
    }

    public function getDeclineButtonColorHover(): string
    {
        return $this->configProvider->getDeclineButtonColorHover() ?: self::DEFAULT_BUTTON_BACKGROUND;
    }

    public function getDeclineTextColor(): string
    {
        return $this->configProvider->getDeclineTextColor() ?: self::DEFAULT_BUTTON_TEXT_COLOR;
    }

    public function getDeclineTextColorHover(): string
    {
        return $this->configProvider->getDeclineTextColorHover() ?: self::DEFAULT_BUTTON_TEXT_COLOR;
    }

    public function getDeclineButtonOrder(): int
    {
        return (int)$this->configProvider->getDeclineButtonOrder();
    }

    public function getFirstShowProcess(): int
    {
        return $this->configProvider->getFirstVisitShow();
    }
}
