<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Analytics GA4 by Amasty
 */

namespace Amasty\GA4\Plugin\GdprCookie\Model\GoogleAnalytics\IsGaCookieAllowed;

use Amasty\GA4\Model\ConfigProvider;
use Amasty\GA4\Model\Cookie\GdprCookieAdapter;
use Amasty\GdprCookie\Model\GoogleAnalytics\IsGaCookieAllowed;

class PreventCookieGtmRemove
{
    /**
     * @var ConfigProvider
     */
    private ConfigProvider $configProvider;

    /**
     * @var GdprCookieAdapter
     */
    private GdprCookieAdapter $gdprCookieAdapter;

    public function __construct(
        ConfigProvider $configProvider,
        GdprCookieAdapter $gdprCookieAdapter
    ) {
        $this->configProvider = $configProvider;
        $this->gdprCookieAdapter = $gdprCookieAdapter;
    }

    public function aroundExecute(IsGaCookieAllowed $subject, callable $proceed): bool
    {
        if (!$this->configProvider->isEnabled() || !$this->gdprCookieAdapter->isModuleValid()) {
            return $proceed();
        }

        return true;
    }
}
