<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Analytics GA4 by Amasty
 */

namespace Amasty\GA4\Model\OptionSource;

use Amasty\GA4\Model\Cookie\GdprCookieAdapter;
use Magento\Framework\Data\OptionSourceInterface;

class CookieGroups implements OptionSourceInterface
{
    /**
     * @var GdprCookieAdapter
     */
    private GdprCookieAdapter $gdprCookieAdapter;

    public function __construct(
        GdprCookieAdapter $gdprCookieAdapter
    ) {
        $this->gdprCookieAdapter = $gdprCookieAdapter;
    }

    public function toOptionArray(): array
    {
        $result = [['value' => 0, 'label' => __('Please Select..')]];
        foreach ($this->toArray() as $value => $label) {
            $result[] = ['value' => $value, 'label' => $label];
        }

        return $result;
    }

    public function toArray(): array
    {
        return $this->gdprCookieAdapter->getCookieGroups();
    }
}
