<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Analytics GA4 by Amasty
 */

namespace Amasty\GA4\Model\GtmMeta;

use Amasty\GA4\Model\ConfigProvider;
use Amasty\GA4Api\Model\GtmMeta\GtmMetaInterface;

class ConsentSettings implements GtmMetaInterface
{
    /**
     * @var ConfigProvider
     */
    private ConfigProvider $configProvider;

    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    public function collect(int $fingerprint = null, array &$data = []): void
    {
        if (!isset($data['containerVersion']['tag']) || !$this->configProvider->isConsentModeEnabled()) {
            return;
        }

        foreach ($data['containerVersion']['tag'] as &$tag) {
            $tag['consentSetting'] = [
                'consentStatus' => 'NOT_NEEDED'
            ];
        }
    }
}
