<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Analytics GA4 by Amasty
 */

namespace Amasty\GA4\Model\Config\Backend\Serialized;

use Magento\Config\Model\Config\Backend\Serialized\ArraySerialized;

class ConsentTypesArraySerialized extends ArraySerialized
{
    public function beforeSave(): ConsentTypesArraySerialized
    {
        if (!is_array($this->getValue()) || empty(array_filter($this->getValue()))) {
            $this->setValue($this->getOldValue());
        }

        return parent::beforeSave();
    }
}
