<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Analytics GA4 by Amasty
 */

namespace Amasty\GA4\Block\Adminhtml\System\Config\InformationBlocks;

use Detection\MobileDetect;
use Magento\Framework\Phrase;
use Magento\Framework\View\Element\Template;

class MobileDetectNotification extends Template
{
    /**
     * @var string
     */
    protected $_template = 'Amasty_GA4::config/information/mobile_detect_notification.phtml';

    public function getNotificationText(): Phrase
    {
        return __(
            'We recommend using the 3rd-party library to improve the mobile detection algorithm. '
            . 'Please, run the following command in the SSH: composer require mobiledetect/mobiledetectlib'
        );
    }

    protected function _toHtml(): string
    {
        if (!$this->isDisplayMessage()) {
            return '';
        }

        return parent::_toHtml();
    }

    private function isDisplayMessage(): bool
    {
        return !class_exists(MobileDetect::class);
    }
}
