<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Analytics GA4 by Amasty
 */

namespace Amasty\GA4\Block\Adminhtml\System\Config\InformationBlocks;

use Amasty\GA4\Model\Cookie\GdprCookieAdapter;
use Amasty\GA4\Model\ThirdParty\ModuleChecker;
use Magento\Framework\View\Element\Template;

class CookieNotification extends Template
{
    /**
     * @var string
     */
    protected $_template = 'Amasty_GA4::config/information/cookie_notification.phtml';

    /**
     * @var GdprCookieAdapter
     */
    private GdprCookieAdapter $cookieAdapter;

    /**
     * @var ModuleChecker
     */
    private ModuleChecker $moduleChecker;

    public function __construct(
        Template\Context $context,
        GdprCookieAdapter $cookieAdapter,
        ModuleChecker $moduleChecker,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->cookieAdapter = $cookieAdapter;
        $this->moduleChecker = $moduleChecker;
    }

    public function getNotificationText(): string
    {
        return __(
            'Upgrade the Cookie Consent (GDPR) module to the version 2.10.1 or newer to enable seamless '
            . 'integration with Google Analytics 4 and gain access to advanced data tracking capabilities.'
        )->render();
    }

    protected function _toHtml()
    {
        if (!$this->isDisplayMessage()) {
            return '';
        }

        return parent::_toHtml();
    }

    private function isDisplayMessage(): bool
    {
        return $this->moduleChecker->isGdprCookieEnabled() && !$this->cookieAdapter->isModuleValid();
    }
}
