<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Analytics GA4 by Amasty
 */

namespace Amasty\GA4\Block\Adminhtml\System\Config;

use Amasty\GA4\Model\Cookie\GdprCookieAdapter;
use Magento\Backend\Block\Context;
use Magento\Backend\Model\Auth\Session;
use Magento\Config\Block\System\Config\Form\Fieldset;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\View\Helper\Js;

class ConsentMode extends Fieldset
{
    /**
     * @var GdprCookieAdapter
     */
    private GdprCookieAdapter $gdprCookieAdapter;

    public function __construct(
        Context $context,
        Session $authSession,
        Js $jsHelper,
        GdprCookieAdapter $gdprCookieAdapter,
        array $data = []
    ) {
        parent::__construct($context, $authSession, $jsHelper, $data);
        $this->gdprCookieAdapter = $gdprCookieAdapter;
    }

    public function render(AbstractElement $element): string
    {
        if ($this->gdprCookieAdapter->isModuleValid()) {
            return parent::render($element);
        }

        return '';
    }
}
