<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Free Gift Hyva Compatibility
 */

namespace Amasty\PromoHyvaCompatibility\ViewModel;

use Amasty\Promo\Model\Config;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class Add implements ArgumentInterface
{
    /**
     * @var Config
     */
    private Config $config;

    /**
     * @param Config $config
     */
    public function __construct(
        Config $config
    ) {
        $this->config = $config;
    }

    /**
     * Get popup link
     *
     * @return mixed|string
     */
    public function getPopupLinkHtml()
    {
        return $this->config->getAddMessage();
    }
}
