<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Free Gift Hyva Compatibility
 */
declare(strict_types=1);

namespace Amasty\PromoHyvaCompatibility\Plugin;

use Hyva\CompatModuleFallback\Model\CompatModuleRegistry;
use Hyva\CompatModuleFallback\Plugin\ViewFileOverride as ViewFileOverrideTest;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Module\Dir as ModuleDir;
use Magento\Framework\View\Design\Fallback\Rule\ModularSwitch;

class ViewFileOverride extends ViewFileOverrideTest
{
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @param CurrentTheme $currentTheme
     * @param ModuleDir $moduleDir
     * @param CompatModuleRegistry $compatModuleRegistry
     * @param RequestInterface $request
     */
    public function __construct(
        CurrentTheme $currentTheme,
        ModuleDir $moduleDir,
        CompatModuleRegistry $compatModuleRegistry,
        RequestInterface $request
    ) {
        $this->request = $request;

        parent::__construct($currentTheme, $moduleDir, $compatModuleRegistry);
    }

    /**
     * Fixed issue with modal popup on checkout
     *
     * @param ModularSwitch $subject
     * @param array $fallbackDirsResult
     * @param array $params
     * @return array
     */
    public function afterGetPatternDirs(ModularSwitch $subject, array $fallbackDirsResult, array $params)
    {

        if ($this->request->getFullActionName() === 'amasty_promo_popup_reload') {
            return $fallbackDirsResult;
        }

        return parent::afterGetPatternDirs($subject, $fallbackDirsResult, $params);
    }
}
