<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Free Gift Hyva Compatibility
 */
declare(strict_types=1);

namespace Amasty\PromoHyvaCompatibility\Plugin;

use Amasty\Promo\Helper\Cart;
use Amasty\PromoGraphql\Model\Resolver\AddFreeGifts;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Quote\Api\CartRepositoryInterface;

class ReCollectQuoteItemsQty
{
    /**
     * @var Cart
     */
    private $amPromoCartHelper;

    /**
     * @var CartRepositoryInterface
     */
    private $cartRepository;

    /**
     * Constructor
     *
     * @param Cart $amPromoCartHelper
     * @param CartRepositoryInterface $cartRepository
     */
    public function __construct(
        Cart $amPromoCartHelper,
        CartRepositoryInterface $cartRepository
    ) {
        $this->amPromoCartHelper = $amPromoCartHelper;
        $this->cartRepository = $cartRepository;
    }

    /**
     * Re-collect quote items qty and prices
     *
     * @param AddFreeGifts $subject
     * @param array $result
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array
     */
    public function afterResolve(
        AddFreeGifts $subject,
        array $result,
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): array {
        if (!empty($result['user_errors']) || !isset($result['cart']['model'])) {
            return $result;
        }

        $quote = $result['cart']['model'];
        $this->amPromoCartHelper->updateTotalQty($quote);

        foreach ($quote->getAllItems() as $item) {
            $item->calcRowTotal();
            $item->save();
        }

        $quote->collectTotals();
        $this->cartRepository->save($quote);

        return $result;
    }
}
