<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Free Gift Hyva Compatibility
 */
declare(strict_types=1);

namespace Amasty\PromoHyvaCompatibility\Model\Resolver;

use Amasty\Promo\Helper\Data;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Amasty\PromoGraphql\Model\QuoteProcessor;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\GraphQl\Model\Query\ContextInterface;

class PromoRuleType implements ResolverInterface
{
    /**
     * @var Data
     */
    private $promoHelper;

    /**
     * @var QuoteProcessor
     */
    private $quoteProcessor;

    /**
     * Constructor
     *
     * @param Data $promoHelper
     * @param QuoteProcessor $quoteProcessor
     */
    public function __construct(
        Data $promoHelper,
        QuoteProcessor $quoteProcessor
    ) {
        $this->promoHelper = $promoHelper;
        $this->quoteProcessor = $quoteProcessor;
    }

    /**
     * Resolver for promo_rule_type
     *
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return string
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): string {
        $quote = $this->quoteProcessor->process($args['cartId'], $context);
        $data = $this->promoHelper->getPromoItemsDataArray($quote);
        $promoData = end($data['triggered_products']);

        return !empty($promoData['rule_type']) ? $promoData['rule_type'] : '0';
    }
}
