<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Ui\DataProvider\Listing;

use Amasty\Fpc\Model\Config\Source\CustomerGroup;

class LogDataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
    /**
     * @var \Amasty\Fpc\Model\ResourceModel\Log\CollectionFactory
     */
    private $collectionFactory;

    public function __construct(
        \Amasty\Fpc\Model\ResourceModel\Log\CollectionFactory $collectionFactory,
        $name,
        $primaryFieldName,
        $requestFieldName,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);

        $this->collectionFactory = $collectionFactory;
    }

    public function getCollection()
    {
        if (!$this->collection) {
            $this->collection = $this->collectionFactory->create();
        }

        return $this->collection;
    }

    public function addFilter(\Magento\Framework\Api\Filter $filter)
    {
        if ($filter->getField() === 'load_time') {
            $filter->setValue(trim($filter->getValue(), '%'));
        } elseif ($filter->getField() === 'customer_group') {
            $groupsData = [];
            foreach ((array)$filter->getValue() as $filterValue) {
                if ($this->isGroupPersistent((string)$filterValue)) {
                    $groupsData['persistentGroups'][] = $this->processPersistentGroup((string)$filterValue);
                } else {
                    $groupsData['systemGroups'][] = $filterValue;
                }
            }

            foreach ($groupsData as $groupType => $groupIds) {
                $this->getCollection()->getSelect()->where(
                    $filter->getField() . ' IN(?) AND `persistent_customer_group` = '
                    . ($groupType == 'systemGroups' ? '0' : '1'),
                    $groupIds
                );
            }

            return;
        }

        parent::addFilter($filter);
    }

    public function addOrder($field, $direction)
    {
        parent::addOrder($field, $direction);

        if ($field == 'customer_group') {
            parent::addOrder('persistent_customer_group', $direction);
        }
    }

    public function getData()
    {
        $result = parent::getData();
        foreach ($result['items'] as &$item) {
            if (!empty($item['persistent_customer_group'])) {
                $item['customer_group'] = CustomerGroup::PERSISTENT_PREFIX . $item['customer_group'];
            }
        }

        return $result;
    }

    private function isGroupPersistent(string $customerGroup): bool
    {
        return strpos($customerGroup, CustomerGroup::PERSISTENT_PREFIX) === 0;
    }

    private function processPersistentGroup(string $customerGroup): int
    {
        return (int)str_replace(CustomerGroup::PERSISTENT_PREFIX, '', $customerGroup);
    }
}
