<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Setup;

use Amasty\Fpc\Model\BackgroundJob\ResourceModel\Job;
use Amasty\Fpc\Model\ResourceModel\Activity;
use Amasty\Fpc\Model\ResourceModel\DebugContext;
use Amasty\Fpc\Model\ResourceModel\FlushesLog;
use Amasty\Fpc\Model\ResourceModel\FlushPages;
use Amasty\Fpc\Model\ResourceModel\Log;
use Amasty\Fpc\Model\ResourceModel\Queue\Page;
use Amasty\Fpc\Model\ResourceModel\Reports;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $this
            ->uninstallTables($setup)
            ->uninstallConfigData($setup);
    }

    private function uninstallTables(SchemaSetupInterface $setup): self
    {
        $tablesToDrop = [
            Activity::TABLE_NAME,
            DebugContext::TABLE_NAME,
            FlushPages::TABLE_NAME,
            Job::TABLE_NAME,
            Log::TABLE_NAME,
            Page::TABLE_NAME,
            Reports::TABLE_NAME,
            FlushesLog::TABLE_NAME
        ];

        foreach ($tablesToDrop as $table) {
            $setup->getConnection()->dropTable(
                $setup->getTable($table)
            );
        }

        return $this;
    }

    private function uninstallConfigData(SchemaSetupInterface $setup): self
    {
        $configTable = $setup->getTable('core_config_data');
        $setup->getConnection()->delete($configTable, "`path` LIKE 'amasty_fpc%'");

        return $this;
    }
}
