<?php

declare(strict_types = 1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Plugin\Framework\Authorization;

use Amasty\Fpc\Helper\Http as HttpHelper;
use Magento\Customer\Model\AccountManagement;
use Magento\Framework\Authorization;

class AllowManageCustomer
{
    /**
     * @var HttpHelper
     */
    private $httpHelper;

    public function __construct(
        HttpHelper $httpHelper
    ) {
        $this->httpHelper = $httpHelper;
    }

    public function afterIsAllowed(
        Authorization $subject,
        bool $result,
        string $resource
    ): bool {
        if ($resource !== AccountManagement::ADMIN_RESOURCE
            || !$this->httpHelper->isCrawlerRequest()
        ) {
            return $result;
        }

        return true;
    }
}
