<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Model\ResourceModel;

use Amasty\Fpc\Model\Reports as ReportsModel;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class Reports extends AbstractDb
{
    public const TABLE_NAME = 'amasty_fpc_reports';

    public function _construct()
    {
        $this->_init(self::TABLE_NAME, ReportsModel::REPORT_ID);
    }

    public function clearTable(string $date): void
    {
        $this->getConnection()->delete($this->getMainTable(), ['date < ?' => $date]);
    }
}
