<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Model\ResourceModel;

use Amasty\Fpc\Api\Data\FlushesLogInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class FlushesLog extends AbstractDb
{
    public const TABLE_NAME = 'amasty_fpc_flushes_log';

    protected function _construct()
    {
        $this->_init(self::TABLE_NAME, FlushesLogInterface::LOG_ID);
    }

    public function truncateTable()
    {
        $this->getConnection()->truncateTable($this->getMainTable());
    }

    public function clearTable(string $date): void
    {
        $this->getConnection()->delete($this->getMainTable(), [FlushesLogInterface::DATE . ' < ?' => $date]);
    }
}
