<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Model\ResourceModel\Activity;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Framework\DB\Select;
use Amasty\Fpc\Model\Activity;
use Amasty\Fpc\Model\ResourceModel\Activity as ActivityResource;

class Collection extends AbstractCollection
{
    public function _construct()
    {
        $this->_init(Activity::class, ActivityResource::class);
        $this->_setIdFieldName($this->getResource()->getIdFieldName());
    }

    /**
     * Get data from activity table
     *
     * @param $queueLimit
     *
     * @return array
     */
    public function getPagesData($queueLimit)
    {
        $this->getSelect()
            ->reset(Select::COLUMNS)
            ->columns(['activity_id' => 'id', 'url', 'rate', 'store'])
            ->where('status NOT IN (?)', [404])
            ->limit($queueLimit);

        return $this->getData();
    }
}
