<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Cron;

use Amasty\Fpc\Model\Config as ConfigProvider;
use Amasty\Fpc\Model\ResourceModel\FlushesLog as FlushesLogResource;
use Amasty\Fpc\Model\ResourceModel\Reports as ReportsResource;
use Magento\Framework\Stdlib\DateTime\DateTime;

class LogCleaner
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var FlushesLogResource
     */
    private $flushesLogResource;

    /**
     * @var ReportsResource
     */
    private $reportsResource;

    /**
     * @var DateTime
     */
    private $dateTime;

    public function __construct(
        ConfigProvider $configProvider,
        FlushesLogResource $flushesLogResource,
        ReportsResource $reportsResource,
        DateTime $dateTime
    ) {
        $this->configProvider = $configProvider;
        $this->flushesLogResource = $flushesLogResource;
        $this->reportsResource = $reportsResource;
        $this->dateTime = $dateTime;
    }

    public function execute(): void
    {
        if (!$this->configProvider->isModuleEnabled()) {
            return;
        }

        if ($this->configProvider->isEnableFlushesLog() && $this->configProvider->isNeedCleanFlushesLog()) {
            $this->flushesLogResource->clearTable(
                $this->getDateByPeriod($this->configProvider->getFlushesLogPeriod())
            );
        }

        if ($this->configProvider->isNeedCleanPerformanceReports()) {
            $this->reportsResource->clearTable(
                $this->getDateByPeriod($this->configProvider->getPerformanceReportsPeriod())
            );
        }
    }

    private function getDateByPeriod(int $period): string
    {
        $time = '-' . $period . ' days';

        return $this->dateTime->gmtDate('Y-m-d H:i:s', $time);
    }
}
