<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Cron;

use Amasty\Fpc\Cron\Consumer\JobConsumerInterface;

class JobQueueConsumer
{
    /**
     * @var ConsumerAdapter
     */
    private $consumerAdapter;

    public function __construct(ConsumerAdapter $consumerAdapter)
    {
        $this->consumerAdapter = $consumerAdapter;
    }

    public function execute()
    {
        /** @var JobConsumerInterface $jobConsumer */
        foreach ($this->consumerAdapter->all() as $jobConsumer) {
            $jobConsumer->consume();
        }
    }
}
