<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Cron;

use Amasty\Fpc\Model\Config;
use Amasty\Fpc\Model\ResourceModel\Activity as ActivityResource;

class ClearActivityLog
{
    /**
     * @var Config
     */
    private $config;

    /**
     * @var ActivityResource
     */
    private $activityResource;

    public function __construct(
        Config $config,
        ActivityResource $activityResource
    ) {
        $this->config = $config;
        $this->activityResource = $activityResource;
    }

    public function execute()
    {
        if (!$this->config->isModuleEnabled()) {
            return;
        }

        if ($this->config->isLogCustomerActivity() && $this->config->isNeedCleanLogCustomerActivity()) {
            $this->activityResource->truncate();
        }
    }
}
