<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Controller\Adminhtml\Queue;

use Amasty\Fpc\Model\Config;
use Amasty\Fpc\Model\Queue;
use Magento\Backend\App\Action\Context;

class Process extends \Amasty\Fpc\Controller\Adminhtml\Queue
{
    /**
     * @var Queue
     */
    private $queue;

    /**
     * @var Config
     */
    private $config;

    public function __construct(
        Context $context,
        Queue $queue,
        Config $config
    ) {
        parent::__construct($context);
        $this->queue = $queue;
        $this->config = $config;
    }

    public function execute()
    {
        try {
            if ($this->config->isModuleEnabled()) {
                $this->queue->process();

                $this->messageManager->addSuccessMessage(
                    __('First batch of warmer queue has been successfully processed.')
                );
            } else {
                $this->messageManager->addWarningMessage(
                    __('The warming queue cannot be generated and warmed up because the module is disabled.')
                );
            }
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        }

        $resultRedirect = $this->resultRedirectFactory->create();

        return $resultRedirect->setPath('*/*/');
    }
}
