<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Full Page Cache Warmer for Magento 2
 */

namespace Amasty\Fpc\Block;

use \Magento\Framework\View\Element\Template;

class Tracking extends Template
{
    /**
     * @var string
     */
    protected $_template = 'Amasty_Fpc::tracking.phtml';

    public function getMageInit()
    {
        return [
            'Amasty_Fpc/js/track' => [
                'url' => $this->getProcessingUrl()
            ],
        ];
    }

    private function getProcessingUrl()
    {
        return $this->_urlBuilder->getUrl('amasty_fpc/reports');
    }
}
