<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Fpc Hyva Compatibility
 */

namespace Amasty\FpcHyvaCompatibility\Plugin\Block\Status;

use Amasty\Fpc\Block\Status;
use Amasty\Fpc\Model\PageStatus;
use Magento\Framework\View\DesignInterface;
use Magento\Framework\View\DesignLoader;

/**
 * Loads theme design in the case when the block instantiated without loading theme(e.g. on page HIT).
 * Templates override functionality requires for the theme to be loaded.
 *
 * @see \Amasty\Fpc\Observer\SendResponseBefore::execute()
 * @see \Hyva\CompatModuleFallback\Plugin\ViewFileOverride::afterGetPatternDirs()
 */
class LoadDesign
{
    /**
     * @var DesignLoader
     */
    private DesignLoader $designLoader;

    /**
     * @var DesignInterface
     */
    private DesignInterface $viewDesign;

    /**
     * @param DesignLoader $designLoader
     * @param DesignInterface $viewDesign
     */
    public function __construct(DesignLoader $designLoader, DesignInterface $viewDesign)
    {
        $this->designLoader = $designLoader;
        $this->viewDesign = $viewDesign;
    }

    /**
     * Load theme design in case it wasn't loaded before
     *
     * @param Status $subject
     * @return void
     */
    public function beforeToHtml(Status $subject): void
    {
        //Check for empty theme's code
        if ($subject->getStatusCode() == PageStatus::STATUS_HIT && !$this->viewDesign->getDesignTheme()->getCode()) {
            $this->designLoader->load();
        }
    }
}
