<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package FAQ and Product Questions Hyva
 */

declare(strict_types=1);

namespace Amasty\FaqHyva\ViewModel;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Amasty\InvisibleCaptcha\Model\ConfigProvider;
use Magento\Framework\Module\Manager;
use Amasty\Faq\Model\ConfigProvider as FaqConfigProvider;

class QuestionsConfig implements ArgumentInterface
{
    /**
     * @var FaqConfigProvider
     */
    private $configProviderFaq;

    /**
     * @var ConfigProvider
     */
    private $configProviderCaptcha;

    /**
     * @var Manager
     */
    private $moduleManager;

    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @param ConfigProvider $configProviderCaptcha
     * @param FaqConfigProvider $configProviderFaq
     * @param Manager $moduleManager
     * @param UrlInterface $urlBuilder
     * @param RequestInterface $request
     */
    public function __construct(
        ConfigProvider $configProviderCaptcha,
        FaqConfigProvider $configProviderFaq,
        Manager $moduleManager,
        UrlInterface $urlBuilder,
        RequestInterface $request
    ) {
        $this->moduleManager = $moduleManager;
        $this->configProviderCaptcha = $configProviderCaptcha;
        $this->configProviderFaq = $configProviderFaq;
        $this->request = $request;
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * Get controller frontname for captcha verification
     *
     * @return string
     */
    public function getVerifyUrl(): string
    {
        return $this->urlBuilder->getUrl(
            $this->urlBuilder->getBaseUrl() . 'faqhyva/grecaptcha/verify',
            ['_secure' => $this->request->isSecure()]
        );
    }

    /**
     * Get is invisible captcha enabled
     *
     * @return bool
     */
    public function getCaptchaEnabled(): bool
    {
        return $this->configProviderCaptcha->isEnabled();
    }

    /**
     * Get is Amasty_SocialLoginHyva module enabled
     *
     * @return bool
     */
    public function isSocialLoginHyvaEnabled(): bool
    {
        return $this->moduleManager->isEnabled('Amasty_SocialLoginHyva');
    }

    /**
     * Get is guest rating allowed
     *
     * @return bool
     */
    public function isGuestRatingAllowed(): bool
    {
        return $this->configProviderFaq->isGuestRatingAllowed();
    }

    /**
     * Retrieve top link label
     *
     * @return string
     */
    public function getTopLinkLabel(): string
    {
        return $this->configProviderFaq->getLabel();
    }

    /**
     * Retrieve url
     *
     * @return string
     */
    public function getTopLinkUrl(): string
    {
        return $this->urlBuilder->getUrl(
            $this->configProviderFaq->getUrlKey()
        );
    }

    /**
     * Check if add to toolbar enabled
     *
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->configProviderFaq->isEnabled();
    }
}
