<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package FAQ and Product Questions Hyva
 */

declare(strict_types=1);

namespace Amasty\FaqHyva\ViewModel;

use Magento\Framework\App\ProductMetadata;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

// phpcs:disable Generic.Files.LineLength.TooLong

class GraphQlQueries implements ArgumentInterface
{
    /**
     * Get Settings
     *
     * @return string
     */
    public function getAmFaqSettings(): string
    {
        return 'getAmFaqSettings {
            isEnabled
            isEnableGdprConsent
            gdprConsentText
            isGuestQuestionsAllowed
        }';
    }

    /**
     * Get Graphql mutation for Place Question
     *
     * @return string
     */
    public function getPlaceAmFaqQuestion(): string
    {
        return 'placeAmFaqQuestion(
            input: { 
                title: $title,
                name: $name,
                email: $email,
                product_id: $product_id,
                category_id: $category_id 
            }) {
                error
                message
        }';
    }

    /**
     * Set FAQ Rating
     *
     * @return string
     */
    public function setFAQRating(): string
    {
        return 'rateAmFaqQuestion(
            input: {
                question_id: $id,
                vote_type: $type,
                value: $value,
                is_revote: $revote,
                old_value: $oldValue
            }) {
                error
                message
            }';
    }
}
