<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package FAQ and Product Questions Hyva
 */

declare(strict_types=1);

namespace Amasty\FaqHyva\Plugin\Widgets;

use Hyva\Theme\Service\CurrentTheme;

class TagsBlock
{
    /** @var CurrentTheme */
    private $currentTheme;

    /**
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        CurrentTheme $currentTheme
    ) {
        $this->currentTheme = $currentTheme;
    }

    /**
     * Add html wrapper
     *
     * @param \Amasty\Faq\Block\Widgets\TagsBlock $subject
     * @param string $result
     */
    public function afterToHtml(\Amasty\Faq\Block\Widgets\TagsBlock $subject, $result)
    {
        if ($this->currentTheme->isHyva()) {
            return '<div class="faq-widget container">'. $result .'</div>';
        }

        return $result;
    }
}
