<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package FAQ and Product Questions Hyva
 */

declare(strict_types=1);

namespace Amasty\FaqHyva\Plugin\Widgets;

use Hyva\Theme\Service\CurrentTheme;

class Categories
{
    /** @var CurrentTheme */
    private $currentTheme;

    /**
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        CurrentTheme $currentTheme
    ) {
        $this->currentTheme = $currentTheme;
    }

    /**
     * Change template before render html
     *
     * @param \Amasty\Faq\Block\Widgets\Categories $subject
     */
    public function beforeToHtml(\Amasty\Faq\Block\Widgets\Categories $subject)
    {
        if ($subject->getTemplate() === 'Amasty_Faq::categories.phtml'
                && $this->currentTheme->isHyva()) {
            $subject->setTemplate('Amasty_FaqHyva::categories.phtml');
        }
    }
}
