<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package FAQ and Product Questions Hyva
 */

declare(strict_types=1);

namespace Amasty\FaqHyva\Plugin\Forms;

use Hyva\Theme\Service\CurrentTheme;

class Search
{
    /** @var CurrentTheme */
    private $currentTheme;

    /**
     * @param CurrentTheme $currentTheme
     */
    public function __construct(
        CurrentTheme $currentTheme
    ) {
        $this->currentTheme = $currentTheme;
    }

    /**
     * Change template before render html
     *
     * @param \Amasty\Faq\Block\Forms\Search $subject
     */
    public function beforeToHtml(\Amasty\Faq\Block\Forms\Search $subject)
    {
        if ($subject->getTemplate() === 'Amasty_Faq::forms/search.phtml'
                && $this->currentTheme->isHyva()) {
            $subject->setTemplate('Amasty_FaqHyva::forms/search.phtml');
        }
    }
}
