<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package FAQ and Product Questions Hyva
 */

declare(strict_types=1);

namespace Amasty\FaqHyva\Plugin;

use Hyva\Theme\ViewModel\Navigation;
use Amasty\Faq\Model\ConfigProvider;
use Amasty\Faq\Model\Url;

class AddFaqLinkToMenu
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var Url
     */
    private $url;

    /**
     * Constructor
     *
     * @param ConfigProvider $configProvider
     * @param Url $url
     */
    public function __construct(
        ConfigProvider $configProvider,
        Url $url
    ) {
        $this->configProvider = $configProvider;
        $this->url = $url;
    }

    /**
     * Add FAQ navigation link to the menu.
     *
     * @param Navigation $subject
     * @param array $result
     * @param bool|int $maxLevel
     * @return array
     * @throws NoSuchEntityException
     */
    public function afterGetNavigation(Navigation $subject, array $result, $maxLevel = false): array
    {
        if (!$this->configProvider->isUseFaqCmsHomePage()
                || !$this->configProvider->isEnabled()
                || !$this->configProvider->isAddToMainMenu()) {
            return $result;
        }

        $result[] = [
            'name' => $this->configProvider->getLabel(),
            'url' => $this->url->getFaqUrl()
        ];

        return $result;
    }
}
