<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package FAQ and Product Questions Hyva
 */

declare(strict_types=1);

namespace Amasty\FaqHyva\Controller\Grecaptcha;

use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Amasty\InvisibleCaptcha\Model\Captcha;
use Magento\Framework\Exception\LocalizedException;

class Verify implements HttpPostActionInterface
{
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var JsonFactory
     */
    private $resultFactory;

    /**
     * @var Captcha
     */
    private $captchaModel;

    /**
     * @param RequestInterface $request
     * @param JsonFactory $resultFactory
     * @param Captcha $captchaModel
     */
    public function __construct(
        RequestInterface $request,
        JsonFactory $resultFactory,
        Captcha $captchaModel
    ) {
        $this->request = $request;
        $this->resultFactory = $resultFactory;
        $this->captchaModel = $captchaModel;
    }

    /**
     * Verified captcha
     *
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $token = $this->request->getParam('token');
        $jsonRresult = $this->resultFactory->create();
        $verification = null;
        $message = '';
        $success = false;

        if ($token) {
            try {
                $verification = $this->captchaModel->verify($token);
                $success = true;
            } catch (LocalizedException $e) {
                $message = $e->getMessage();
            } catch (\Exception $e) {
                $message = __('Something went wrong while verifying recaptcha');
            }
        } else {
            $message = __('Token not sent or empty');
        }

        return $jsonRresult->setData([
            'success'        => $success,
            'error_message'  => $message,
            'verification'   => $verification
        ]);
    }
}
