<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Faq Graph Ql for Magento 2 (System)
 */

namespace Amasty\FaqGraphQl\Model\CollectionProcessor\Question\Join;

use Amasty\Faq\Api\Data\QuestionInterface;
use Amasty\Faq\Api\Data\TagInterface;
use Amasty\Faq\Model\ResourceModel\Question;
use Amasty\Faq\Model\ResourceModel\Tag as TagResourceModel;
use Magento\Framework\Api\SearchCriteria\CollectionProcessor\JoinProcessor\CustomJoinInterface;
use Magento\Framework\Data\Collection\AbstractDb;

class Tag implements CustomJoinInterface
{
    public function apply(AbstractDb $collection)
    {
        $collection->getSelect()->joinLeft(
            [
                Question::TAG_LINK_TABLE_NAME => $collection->getTable(Question::TAG_LINK_TABLE_NAME)
            ],
            'main_table.' . QuestionInterface::QUESTION_ID . ' = '
            . Question::TAG_LINK_TABLE_NAME . '.' . QuestionInterface::QUESTION_ID,
            []
        )->joinLeft(
            [
                TagResourceModel::TABLE_NAME => $collection->getTable(TagResourceModel::TABLE_NAME)
            ],
            Question::TAG_LINK_TABLE_NAME . '.' . TagInterface::TAG_ID . ' = '
            . TagResourceModel::TABLE_NAME . '.' . TagInterface::TAG_ID,
            []
        );
        $collection->distinct(true);
    }
}
