<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Faq Graph Ql for Magento 2 (System)
 */

namespace Amasty\FaqGraphQl\Model\CollectionProcessor\Question\Join;

use Amasty\Faq\Api\Data\QuestionInterface;
use Amasty\Faq\Model\ResourceModel\Question;
use Magento\Framework\Api\SearchCriteria\CollectionProcessor\JoinProcessor\CustomJoinInterface;
use Magento\Framework\Data\Collection\AbstractDb;

class CategoryId implements CustomJoinInterface
{
    public function apply(AbstractDb $collection)
    {
        $collection->getSelect()->joinLeft(
            [Question::CATEGORY_LINK_TABLE_NAME => $collection->getTable(Question::CATEGORY_LINK_TABLE_NAME)],
            'main_table.' . QuestionInterface::QUESTION_ID . ' = '
            . Question::CATEGORY_LINK_TABLE_NAME . '.' . QuestionInterface::QUESTION_ID,
            []
        );
        $collection->distinct(true);
    }
}
