<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Faq Graph Ql for Magento 2 (System)
 */

namespace Amasty\FaqGraphQl\Model\CollectionProcessor\Category\Join;

use Amasty\Faq\Api\Data\CategoryInterface;
use Amasty\Faq\Model\ResourceModel\Category;
use Magento\Framework\Api\SearchCriteria\CollectionProcessor\JoinProcessor\CustomJoinInterface;
use Magento\Framework\Data\Collection\AbstractDb;

class CustomerGroupId implements CustomJoinInterface
{
    public function apply(AbstractDb $collection)
    {
        $collection->getSelect()->joinLeft(
            [
                Category::CUSTOMER_GROUPS_LINK_TABLE_NAME =>
                    $collection->getTable(Category::CUSTOMER_GROUPS_LINK_TABLE_NAME)
            ],
            'main_table.' . CategoryInterface::CATEGORY_ID . ' = '
            . Category::CUSTOMER_GROUPS_LINK_TABLE_NAME . '.' . CategoryInterface::CATEGORY_ID,
            []
        );
        $collection->distinct(true);
    }
}
