/**
 * @api
 */
define([
    'Magento_Ui/js/form/element/select'
], function (Select) {
    'use strict';

    return Select.extend({
        defaults: {
            isEnabled: 0,
            listens: {
                value: 'toggleVisibility'
            }
        },

        /** @inheritDoc */
        initObservable: function () {
            this._super()
                .observe('isEnabled');

            return this;
        },

        /**
         * Set isEnabled value based on selected value
         * @param {String} value
         * @returns {Object}
         */
        toggleVisibility: function (value) {
            this.isEnabled(+value);

            return this;
        }
    });
});
