<?php
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixelPro\Test\Unit\Model;

use Amasty\FacebookPixelPro\Model\UserInfoProvider;
use Amasty\FacebookPixelPro\Test\Unit\Traits;
use Magento\Customer\Model\Session;
use Magento\Framework\HTTP\Header;
use Magento\Framework\HTTP\PhpEnvironment\RemoteAddress;
use PHPUnit\Framework\TestCase;

class UserInfoProviderTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixelPro\Model\UserInfoProvider::getUserInfo
     *
     * @dataProvider getUserInfoDataProvider
     */
    public function testGetUserInfo($ip, $userAgent, $expectedResult)
    {
        $model = $this->getObjectManager()->getObject(UserInfoProvider::class);

        $httpHeader = $this->getMockBuilder(Header::class)
            ->disableOriginalConstructor()
            ->setMethods(['getHttpUserAgent'])
            ->getMock();
        $remoteAddress = $this->getMockBuilder(RemoteAddress::class)
            ->disableOriginalConstructor()
            ->setMethods(['getRemoteAddress'])
            ->getMock();
        $customerSession = $this->getMockBuilder(Session::class)
            ->disableOriginalConstructor()
            ->setMethods(['isLoggedIn'])
            ->getMock();

        $httpHeader->expects($this->any())->method('getHttpUserAgent')->willReturn($userAgent);
        $remoteAddress->expects($this->any())->method('getRemoteAddress')->willReturn($ip);
        $customerSession->expects($this->any())->method('isLoggedIn')->willReturn(false);


        $this->setProperty($model, 'httpHeader', $httpHeader, UserInfoProvider::class);
        $this->setProperty($model, 'remoteIp', $remoteAddress, UserInfoProvider::class);
        $this->setProperty($model, 'customerSession', $customerSession, UserInfoProvider::class);
        $this->assertEquals($expectedResult, $model->getUserInfo());
    }

    /**
     * @return array
     */
    public function getUserInfoDataProvider()
    {
        return [
            [
                '127.0.0.1',
                'test_user_agent',
                [
                    'client_ip_address' => '127.0.0.1',
                    'client_user_agent' => 'test_user_agent'
                ]
            ],
        ];
    }
}
