<?php
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixelPro\Test\Unit\Model\Api;

use Amasty\FacebookPixelPro\Model\EventData\EventDataGeneratorPool;
use Amasty\FacebookPixelPro\Test\Unit\Traits;
use Magento\Framework\Exception\LocalizedException;
use PHPUnit\Framework\TestCase;

class EventDataGeneratorPoolTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixelPro\Model\EventData\EventDataGeneratorPool::initDataGenerator
     */
    public function testInitDataGenerator()
    {
        $generatorPool = $this->getObjectManager()->getObject(EventDataGeneratorPool::class);
        $this->setProperty($generatorPool, 'eventDataGenerators', []);

        $this->expectException(LocalizedException::class);
        $this->expectExceptionMessage('Event Data Generator with test_event_code code is not declared');

        $this->invokeMethod($generatorPool, 'initDataGenerator', ['test_event_code']);
    }
}
