<?php
/**
 * @codingStandardsIgnoreFile
 */
namespace Amasty\FacebookPixelPro\Test\Unit\Model\Api;

use Amasty\FacebookPixelPro\Model\Api\ApiCaller;
use Amasty\FacebookPixelPro\Test\Unit\Traits;
use PHPUnit\Framework\TestCase;

class ApiCallerTest extends TestCase
{
    use Traits\ObjectManagerTrait;
    use Traits\ReflectionTrait;

    /**
     * @covers \Amasty\FacebookPixelPro\Model\Api\ApiCaller::getEndpointUrl
     *
     * @dataProvider getEndpointUrlDataProvider
     */
    public function testGetEndpointUrl($pixelId, $token, $expectedResult)
    {
        $apiCaller = $this->getObjectManager()->getObject(ApiCaller::class);

        $this->assertEquals(
            $expectedResult,
            $this->invokeMethod($apiCaller, 'getEndpointUrl', [$pixelId, $token])
        );
    }

    /**
     * @return array
     */
    public function getEndpointUrlDataProvider()
    {
        return [
            [
                '10000',
                'test_token',
                'https://graph.facebook.com/v12.0/10000/events?access_token=test_token'
            ],
        ];
    }
}
