<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Plugin\FacebookPixel\Model\EventProcessor;

use Amasty\FacebookPixel\Model\ConfigProvider;
use Amasty\FacebookPixel\Model\EventProcessor;
use Amasty\FacebookPixelPro\Model\EventProcessor as ServerEventProcessor;
use Psr\Log\LoggerInterface;

class ProcessServerSideEvents
{
    /**
     * @var ServerEventProcessor
     */
    private $eventProcessor;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ServerEventProcessor $eventProcessor,
        LoggerInterface $logger,
        ConfigProvider $configProvider
    ) {
        $this->eventProcessor = $eventProcessor;
        $this->logger = $logger;
        $this->configProvider = $configProvider;
    }

    /**
     * @param EventProcessor $subject
     * @param array|null $result
     * @param string $eventCode
     * @param int $eventId
     * @param null $data
     * @param null $eventData
     * @return array|null
     */
    public function afterGetEventsDataForPixels(
        EventProcessor $subject,
        ?array $result,
        string $eventCode,
        int $eventId,
        $data = null,
        $eventData = null
    ): ?array {
        if (!$this->configProvider->isFacebookPixelEnabled()) {
            return $result;
        }

        try {
            $this->eventProcessor->processEvent($eventCode, $eventId, $data, $eventData);
        } catch (\Exception $e) {
            $this->logger->critical($e);
        }

        return $result;
    }
}
