<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Plugin\FacebookPixel\Api\PixelRepositoryInterface;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Api\PixelRepositoryInterface;
use Amasty\FacebookPixelPro\Api\ServerSideSettingsRepositoryInterface;
use Exception;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Psr\Log\LoggerInterface;

class AddExtensionAttribute
{
    /**
     * @var ServerSideSettingsRepositoryInterface
     */
    private $serverSideDataRepository;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param ServerSideSettingsRepositoryInterface $serverSideDataRepository
     * @param LoggerInterface $logger
     */
    public function __construct(
        ServerSideSettingsRepositoryInterface $serverSideDataRepository,
        LoggerInterface $logger
    ) {
        $this->serverSideDataRepository = $serverSideDataRepository;
        $this->logger = $logger;
    }

    /**
     * @param PixelRepositoryInterface $subject
     * @param PixelInterface $result
     * @return PixelInterface
     */
    public function afterGetById(PixelRepositoryInterface $subject, PixelInterface $pixel): PixelInterface
    {
        try {
            $serverSideData = $this->serverSideDataRepository->getByPixelEntityId((int)$pixel->getId());
        } catch (NoSuchEntityException $e) {
            return $pixel;
        }

        $extensionAttributes = $pixel->getExtensionAttributes();
        $extensionAttributes->setServerSideData($serverSideData);
        $pixel->setExtensionAttributes($extensionAttributes);

        return $pixel;
    }

    /**
     * @param PixelRepositoryInterface $subject
     * @param SearchResultsInterface $pixelSearchResults
     * @return SearchResultsInterface
     */
    public function afterGetList(
        PixelRepositoryInterface $subject,
        SearchResultsInterface $pixelSearchResults
    ): SearchResultsInterface {
        foreach ($pixelSearchResults->getItems() as $pixel) {
            try {
                $serverSideData = $this->serverSideDataRepository->getByPixelEntityId((int)$pixel->getId());
            } catch (NoSuchEntityException $e) {
                continue;
            }

            $extensionAttributes = $pixel->getExtensionAttributes();
            $extensionAttributes->setServerSideData($serverSideData);
            $pixel->setExtensionAttributes($extensionAttributes);
        }

        return $pixelSearchResults;
    }

    /**
     * @param PixelRepositoryInterface $subject
     * @param PixelInterface $result
     * @param PixelInterface $entity
     * @return PixelInterface
     */
    public function afterSave(
        PixelRepositoryInterface $subject,
        PixelInterface $result,
        PixelInterface $entity
    ): PixelInterface {
        $extensionAttributes = $entity->getExtensionAttributes();
        $serverSideData = $extensionAttributes->getServerSideData();

        if ($serverSideData) {
            if ($serverSideData->getId() === null) {
                try {
                    $serverSideDataId = $this->serverSideDataRepository->getByPixelEntityId((int)$result->getId())
                        ->getId();
                } catch (NoSuchEntityException $e) {
                    $serverSideDataId = null;
                }

                if ($serverSideDataId !== null) {
                    $serverSideData->setId($serverSideDataId);
                }
            }

            try {
                $serverSideData->setPixelEntityId((int)$result->getId());

                $this->serverSideDataRepository->save($serverSideData);
                $resultAttributes = $result->getExtensionAttributes();
                $resultAttributes->setServerSideData($serverSideData);
                $result->setExtensionAttributes($resultAttributes);
            } catch (Exception $e) {
                $this->logger->critical($e);
            }
        }

        return $result;
    }
}
