<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Plugin\FacebookPixel\Api\Data\PixelInterface;

use Amasty\FacebookPixel\Api\Data\PixelExtensionInterface;
use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Api\Data\PixelExtensionFactory;

class LoadExtensionAttributes
{
    /**
     * @var PixelExtensionFactory
     */
    private $pixelExtensionFactory;

    /**
     * @param PixelExtensionFactory $pixelExtensionFactory
     */
    public function __construct(PixelExtensionFactory $pixelExtensionFactory)
    {
        $this->pixelExtensionFactory = $pixelExtensionFactory;
    }

    /**
     * @param PixelInterface $subject
     * @param PixelExtensionInterface|null $extension
     * @return PixelExtensionInterface|null
     */
    public function afterGetExtensionAttributes(
        PixelInterface $subject,
        ?PixelExtensionInterface $extension = null
    ): ?PixelExtensionInterface {
        if ($extension === null) {
            $extension = $this->pixelExtensionFactory->create();
        }

        return $extension;
    }
}
