<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model;

use Magento\Customer\Model\Session;
use Magento\Framework\HTTP\Header;
use Magento\Framework\HTTP\PhpEnvironment\RemoteAddress;

class UserInfoProvider
{
    /**
     * @var Header
     */
    private $httpHeader;

    /**
     * @var RemoteAddress
     */
    private $remoteIp;

    /**
     * @var Session
     */
    private $customerSession;

    public function __construct(
        Header $httpHeader,
        RemoteAddress $remoteIp,
        Session $customerSession
    ) {
        $this->httpHeader = $httpHeader;
        $this->remoteIp = $remoteIp;
        $this->customerSession = $customerSession;
    }

    /**
     * @return array
     */
    public function getUserInfo(): array
    {
        $userData = [
            'client_ip_address' => $this->remoteIp->getRemoteAddress(),
            'client_user_agent' => $this->httpHeader->getHttpUserAgent(false)
        ];

        if ($this->customerSession->isLoggedIn()) {
            $loggedInData = [
                'em' => hash('sha256', $this->customerSession->getCustomer()->getEmail()),
                'fn' => hash('sha256', (string)$this->customerSession->getCustomer()->getFirstname()),
                'ln' => hash('sha256', (string)$this->customerSession->getCustomer()->getLastname()),
            ];
            $userData = array_merge($userData, $loggedInData);
        }

        return $userData;
    }
}
