<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model;

use Amasty\FacebookPixelPro\Api\Data\ServerSideSettingsInterface;
use Magento\Framework\Model\AbstractModel;

class ServerSideSettings extends AbstractModel implements ServerSideSettingsInterface
{
    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\ServerSideSettings::class);
    }

    /**
     * @param int $entityId
     * @return ServerSideSettingsInterface
     */
    public function setId($entityId): ServerSideSettingsInterface
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->getData(self::ENTITY_ID) !== null
            ? (int)$this->getData(self::ENTITY_ID) : null;
    }

    /**
     * @param int $pixelEntityId
     * @return ServerSideSettingsInterface
     */
    public function setPixelEntityId(int $pixelEntityId): ServerSideSettingsInterface
    {
        return $this->setData(self::PIXEL_ENTITY_ID, $pixelEntityId);
    }

    /**
     * @return int|null
     */
    public function getPixelEntityId(): ?int
    {
        return $this->getData(self::PIXEL_ENTITY_ID) !== null
            ? (int)$this->getData(self::PIXEL_ENTITY_ID) : null;
    }

    /**
     * @param string $token
     * @return ServerSideSettingsInterface
     */
    public function setToken(string $token): ServerSideSettingsInterface
    {
        return $this->setData(self::TOKEN, $token);
    }

    /**
     * @return string|null
     */
    public function getToken(): ?string
    {
        return $this->getData(self::TOKEN);
    }

    /**
     * @param string|null $testEventCode
     * @return ServerSideSettingsInterface
     */
    public function setTestEventCode(?string $testEventCode): ServerSideSettingsInterface
    {
        return $this->setData(self::TEST_EVENT_CODE, $testEventCode);
    }

    /**
     * @return string|null
     */
    public function getTestEventCode(): ?string
    {
        return $this->getData(self::TEST_EVENT_CODE);
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsCategoryViewEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_CATEGORY_VIEW_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsCategoryViewEnabled(): ?bool
    {
        return $this->getData(self::IS_CATEGORY_VIEW_ENABLED) !== null
            ? (bool)$this->getData(self::IS_CATEGORY_VIEW_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsProductViewEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_PRODUCT_VIEW_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsProductViewEnabled(): ?bool
    {
        return $this->getData(self::IS_PRODUCT_VIEW_ENABLED) !== null
            ? (bool)$this->getData(self::IS_PRODUCT_VIEW_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsInitiateCheckoutEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_INIT_CHECKOUT_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsInitiateCheckoutEnabled(): ?bool
    {
        return $this->getData(self::IS_INIT_CHECKOUT_ENABLED) !== null
            ? (bool)$this->getData(self::IS_INIT_CHECKOUT_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsPurchaseEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_PURCHASE_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsPurchaseEnabled(): ?bool
    {
        return $this->getData(self::IS_PURCHASE_ENABLED) !== null
            ? (bool)$this->getData(self::IS_PURCHASE_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsSearchEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_SEARCH_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsSearchEnabled(): ?bool
    {
        return $this->getData(self::IS_SEARCH_ENABLED) !== null
            ? (bool)$this->getData(self::IS_SEARCH_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsAddToCartEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_ADD_TO_CART_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsAddToCartEnabled(): ?bool
    {
        return $this->getData(self::IS_ADD_TO_CART_ENABLED) !== null
            ? (bool)$this->getData(self::IS_ADD_TO_CART_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsAddToWishlistEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_ADD_TO_WISHLIST_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsAddToWishlistEnabled(): ?bool
    {
        return $this->getData(self::IS_ADD_TO_WISHLIST_ENABLED) !== null
            ? (bool)$this->getData(self::IS_ADD_TO_WISHLIST_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsRegistrationEnabled(bool $isEnabled): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_REGISTRATION_ENABLED, $isEnabled);
    }

    /**
     * @return bool|null
     */
    public function getIsRegistrationEnabled(): ?bool
    {
        return $this->getData(self::IS_REGISTRATION_ENABLED) !== null
            ? (bool)$this->getData(self::IS_REGISTRATION_ENABLED) : null;
    }

    /**
     * @param bool $isEnabled
     * @return ServerSideSettingsInterface
     */
    public function setIsActive(bool $isActive): ServerSideSettingsInterface
    {
        return $this->setData(self::IS_ACTIVE, $isActive);
    }

    /**
     * @return bool|null
     */
    public function getIsActive(): ?bool
    {
        return $this->getData(self::IS_ACTIVE) !== null
            ? (bool)$this->getData(self::IS_ACTIVE) : null;
    }
}
