<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\ResourceModel;

use Amasty\FacebookPixelPro\Api\Data\EventQueueInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class EventQueue extends AbstractDb
{
    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(EventQueueInterface::MAIN_TABLE, EventQueueInterface::ENTITY_ID);
    }

    /**
     * @param array $ids
     * @throws LocalizedException
     */
    public function deleteByIds(array $ids = []): void
    {
        $this->getConnection()->delete($this->getMainTable(), [EventQueueInterface::ENTITY_ID . ' in (?) ' => $ids]);
    }
}
