<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model;

use Amasty\FacebookPixelPro\Api\Data\EventQueueInterface;
use Amasty\FacebookPixelPro\Model\ResourceModel\EventQueue as EventQueueResource;
use Amasty\FacebookPixelPro\Model\ResourceModel\EventQueue\CollectionFactory;
use Magento\Framework\Exception\LocalizedException;

class QueueService
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var EventQueueResource
     */
    private $eventQueueResource;

    public function __construct(
        CollectionFactory $collectionFactory,
        EventQueueResource $eventQueueResource
    ) {
        $this->collectionFactory = $collectionFactory;
        $this->eventQueueResource = $eventQueueResource;
    }

    /**
     * @return bool
     */
    public function isQueueEmpty(): bool
    {
        return !(bool)$this->collectionFactory->create()->getSize();
    }

    /**
     * @param int $limit
     * @return array
     * @throws LocalizedException
     */
    public function shuffleQueues(int $limit): array
    {
        $queueCollection = $this->collectionFactory->create();
        $queueCollection->setPageSize($limit);
        $ids = [];
        $items = $queueCollection->getItems();

        /** @var EventQueueInterface $item */
        foreach ($items as $item) {
            $ids[] = $item->getId();
        }

        if (!empty($ids)) {
            $this->eventQueueResource->deleteByIds($ids);
        }

        return $items;
    }
}
