<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model;

use Amasty\FacebookPixelPro\Api\Data\EventQueueInterface;
use Magento\Framework\Model\AbstractModel;

class EventQueue extends AbstractModel implements EventQueueInterface
{
    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\EventQueue::class);
    }

    /**
     * @param int $entityId
     * @return EventQueueInterface
     */
    public function setId($entityId): EventQueueInterface
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->getData(self::ENTITY_ID) !== null
            ? (int)$this->getData(self::ENTITY_ID) : null;
    }

    /**
     * @param string $pixelId
     * @return EventQueueInterface
     */
    public function setPixelId(string $pixelId): EventQueueInterface
    {
        return $this->setData(self::PIXEL_ID, $pixelId);
    }

    /**
     * @return string|null
     */
    public function getPixelId(): ?string
    {
        return $this->getData(self::PIXEL_ID) ?? null;
    }

    /**
     * @param string $token
     * @return EventQueueInterface
     */
    public function setToken(string $token): EventQueueInterface
    {
        return $this->setData(self::TOKEN, $token);
    }

    /**
     * @return string|null
     */
    public function getToken(): ?string
    {
        return $this->getData(self::TOKEN);
    }

    /**
     * @param string|null $testEventCode
     * @return EventQueueInterface
     */
    public function setTestEventCode(?string $testEventCode): EventQueueInterface
    {
        return $this->setData(self::TEST_EVENT_CODE, $testEventCode);
    }

    /**
     * @return string|null
     */
    public function getTestEventCode(): ?string
    {
        return $this->getData(self::TEST_EVENT_CODE);
    }

    /**
     * @param string $eventData
     * @return EventQueueInterface
     */
    public function setEventData(string $eventData): EventQueueInterface
    {
        return $this->setData(self::EVENT_DATA, $eventData);
    }

    /**
     * @return string|null
     */
    public function getEventData(): ?string
    {
        return $this->getData(self::EVENT_DATA);
    }
}
