<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Model\EventData\EventDataGenerator\Search as PixelSearch;

class Search extends PixelSearch implements EventDataGeneratorInterface
{
    private const EVENT_NAME = 'Search';

    /**
     * @return string
     */
    public function getEventName(): string
    {
        return self::EVENT_NAME;
    }

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return (bool)$pixel->getExtensionAttributes()->getServerSideData()->getIsSearchEnabled();
    }
}
