<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Model\EventData\EventDataGenerator\Registration as PixelRegistration;

class Registration extends PixelRegistration implements EventDataGeneratorInterface
{
    private const EVENT_NAME = 'CompleteRegistration';

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return (bool)$pixel->getExtensionAttributes()->getServerSideData()->getIsRegistrationEnabled();
    }

    /**
     * @return string
     */
    public function getEventName(): string
    {
        return self::EVENT_NAME;
    }
}
