<?php

declare(strict_types=1);

namespace Amasty\FacebookPixelPro\Model\EventData\EventDataGenerator;

use Amasty\FacebookPixel\Api\Data\PixelInterface;
use Amasty\FacebookPixel\Model\EventData\EventDataGenerator\InitCheckout as PixelInitCheckout;

class InitCheckout extends PixelInitCheckout implements EventDataGeneratorInterface
{
    private const EVENT_NAME = 'InitiateCheckout';

    /**
     * @return string
     */
    public function getEventName(): string
    {
        return self::EVENT_NAME;
    }

    /**
     * @param PixelInterface $pixel
     * @return bool
     */
    public function isEventEnabledForPixel(PixelInterface $pixel): bool
    {
        return (bool)$pixel->getExtensionAttributes()->getServerSideData()->getIsInitiateCheckoutEnabled();
    }
}
